﻿using System;
using System.Collections.Generic;

namespace Microscopic_Traffic_Simulator.ViewModels.Messages
{
    /// <summary>
    /// Class representing message without payload.
    /// </summary>
    abstract class Message : MessageBase
    {
        /// <summary>
        /// List of subscribers of message.
        /// </summary>
        private HashSet<Action> subscribers = new HashSet<Action>();

        /// <summary>
        /// Subscribe to this message.
        /// </summary>
        /// <param name="subscriber">Action executed after receiving this message.</param>
        internal void Subscribe(Action subscriber)
        {
            subscribers.Add(subscriber);
        }

        /// <summary>
        /// Unsubscribe from this message.
        /// </summary>
        /// <param name="subscriber">Action executed after receiving this message.</param>
        internal void Unsubcsribe(Action subscriber)
        {
            subscribers.Remove(subscriber);
        }

        /// <summary>
        /// Publish message to all subscribers.
        /// </summary>
        internal void Publish()
        {
            foreach (Action subscriber in subscribers)
            {
                subscriber();
            }
        }
    }
}
